/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.task.TaskErrorIds;
import com.ibm.hwmca.fw.util.Trace;
import java.lang.reflect.Method;

public class HThreadGroup
extends ThreadGroup
implements TaskErrorIds {
    private static final String TRACE_MASKT = "XFRMHTGT";
    private static final String TRACE_MASKF = "XFRMHTGF";
    private static final String TRACE_MASKD = "XFRMHTGD";
    private static final String MEM_TRACE_MASKT = "HOSMJAVT";
    private static final String MEM_TRACE_MASKF = "HOSMJAVF";
    private static final String MEM_TRACE_MASKD = "HOSMJAVD";
    private static Object memoryLogLock = new Object();
    private static boolean memoryLogTaken = false;
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "HThreadGrp");
    private static HThreadGroup defaultThreadGroup = new HThreadGroup();
    private static int nextid = 1;
    private static Object idLock = new Object();
    private static boolean outOfMemoryCaught = false;

    private HThreadGroup() throws NullPointerException, SecurityException {
        super("Default");
    }

    public HThreadGroup(String name) throws NullPointerException, SecurityException {
        super(defaultThreadGroup, name);
    }

    public HThreadGroup(HThreadGroup parent, String name) throws NullPointerException, SecurityException {
        super(parent, name);
    }

    public static HThreadGroup defaultThreadGroup() {
        return defaultThreadGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread createThread(Runnable target, String name) throws SecurityException {
        String thdName = name;
        if (thdName == null) {
            thdName = "HThread";
        }
        Object object = idLock;
        synchronized (object) {
            thdName = thdName + "-" + nextid;
            ++nextid;
        }
        return new Thread(this, target, thdName);
    }

    public void uncaughtException(Thread t, Throwable e) {
        ThreadGroup parent = this.getParent();
        if (this.equals(defaultThreadGroup) || parent == null) {
            if (!(e instanceof ThreadDeath)) {
                Trace.trace(TRACE_MASKT, "-> HThreadGroup.uncaughtException()");
                boolean logit = true;
                if (outOfMemoryCaught && e instanceof OutOfMemoryError) {
                    logit = false;
                }
                if (!outOfMemoryCaught && e instanceof OutOfMemoryError) {
                    outOfMemoryCaught = true;
                    HThreadGroup.forceDump();
                }
                Trace.trace(TRACE_MASKT, e);
                if (logit) {
                    FrameworkLog log = new FrameworkLog(classLogInfo, 70, e);
                    log.add(e.toString());
                    log.log();
                }
                Trace.trace(TRACE_MASKT, "<- HThreadGroup.uncaughtException()");
            }
        } else {
            parent.uncaughtException(t, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int checkMemory(int minimumPercentFree, int resumeLoggingPercent) {
        int rc;
        block11: {
            Trace.trace(MEM_TRACE_MASKT, "-> HThreadGroup.checkMemory()");
            rc = 0;
            try {
                Long max = new Long(Runtime.getRuntime().maxMemory());
                Long free = new Long(Runtime.getRuntime().freeMemory());
                Long total = new Long(Runtime.getRuntime().totalMemory());
                StringBuffer buf1 = new StringBuffer("JVM maximum memory=");
                buf1.append(max);
                buf1.append("; total memory=");
                buf1.append(total);
                buf1.append("; free memory=");
                buf1.append(free);
                Trace.trace(MEM_TRACE_MASKF, buf1.toString());
                double maxMem = max.doubleValue();
                double freeMem = maxMem - total.doubleValue() + free.doubleValue();
                double freeThreshold = new Integer(minimumPercentFree).doubleValue() / 10.0;
                double freePercent = freeMem / maxMem * 100.0;
                if (freePercent < freeThreshold) {
                    StringBuffer buf = new StringBuffer("Free memory threshold exceeded; free memory=");
                    buf.append(freeMem);
                    buf.append("; percent free=");
                    buf.append(freePercent);
                    buf.append("; threshold=");
                    buf.append(freeThreshold);
                    Trace.trace(MEM_TRACE_MASKF, buf.toString());
                    Object object = memoryLogLock;
                    synchronized (object) {
                        if (!memoryLogTaken) {
                            Trace.trace(MEM_TRACE_MASKF, "taking JVM dump and memory monitor log");
                            memoryLogTaken = true;
                            HThreadGroup.forceDump();
                            FrameworkLog log = new FrameworkLog(classLogInfo, 76);
                            log.add(buf1.toString());
                            log.add(buf.toString());
                            log.log();
                            rc = 1;
                        } else {
                            Trace.trace(MEM_TRACE_MASKF, "skipping memory monitor log, since it was already taken");
                        }
                    }
                    System.gc();
                    break block11;
                }
                StringBuffer buf = new StringBuffer("Free memory threshold NOT exceeded; free memory=");
                buf.append(freeMem);
                buf.append("; percent free=");
                buf.append(freePercent);
                buf.append("; threshold=");
                buf.append(freeThreshold);
                Trace.trace(MEM_TRACE_MASKF, buf.toString());
                double resumeThreshold = new Integer(resumeLoggingPercent).doubleValue() / 10.0;
                if (!(freePercent > resumeThreshold) || !memoryLogTaken) break block11;
                StringBuffer buf2 = new StringBuffer("Resetting log flag since free memory below resume threshold of ");
                buf2.append(resumeThreshold);
                Trace.trace(MEM_TRACE_MASKF, buf2.toString());
                Object object = memoryLogLock;
                synchronized (object) {
                    memoryLogTaken = false;
                }
            }
            catch (Exception e) {
                rc = -1;
                Trace.trace(MEM_TRACE_MASKF, e);
            }
        }
        Trace.trace(MEM_TRACE_MASKT, "<- HThreadGroup.checkMemory()");
        return rc;
    }

    private static void forceDump() {
        try {
            Class<?> dumpClass = Class.forName("com.ibm.jvm.Dump");
            Method method = dumpClass.getMethod("JavaDump", null);
            method.invoke(null, null);
            method = dumpClass.getMethod("HeapDump", null);
            method.invoke(null, null);
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
    }
}

